/**
 * Generated by Verge3D Puzzles v.3.8.3
 * Thu Oct 28 2021 14:58:57 GMT+0300 (Moscow Standard Time)
 * Prefer not editing this file as your changes may get overridden once Puzzles are saved.
 * Check out https://www.soft8soft.com/docs/manual/en/introduction/Using-JavaScript.html
 * for the information on how to add your own JavaScript to Verge3D apps.
 */

'use strict';

(function() {

// global variables/constants used by puzzles' functions

var LIST_NONE = '<none>';

var _pGlob = {};

_pGlob.objCache = {};
_pGlob.fadeAnnotations = true;
_pGlob.pickedObject = '';
_pGlob.hoveredObject = '';
_pGlob.mediaElements = {};
_pGlob.loadedFile = '';
_pGlob.states = [];
_pGlob.percentage = 0;
_pGlob.openedFile = '';
_pGlob.xrSessionAcquired = false;
_pGlob.xrSessionCallbacks = [];
_pGlob.screenCoords = new v3d.Vector2();
_pGlob.intervalTimers = {};

_pGlob.AXIS_X = new v3d.Vector3(1, 0, 0);
_pGlob.AXIS_Y = new v3d.Vector3(0, 1, 0);
_pGlob.AXIS_Z = new v3d.Vector3(0, 0, 1);
_pGlob.MIN_DRAG_SCALE = 10e-4;
_pGlob.SET_OBJ_ROT_EPS = 1e-8;

_pGlob.vec2Tmp = new v3d.Vector2();
_pGlob.vec2Tmp2 = new v3d.Vector2();
_pGlob.vec3Tmp = new v3d.Vector3();
_pGlob.vec3Tmp2 = new v3d.Vector3();
_pGlob.vec3Tmp3 = new v3d.Vector3();
_pGlob.vec3Tmp4 = new v3d.Vector3();
_pGlob.eulerTmp = new v3d.Euler();
_pGlob.eulerTmp2 = new v3d.Euler();
_pGlob.quatTmp = new v3d.Quaternion();
_pGlob.quatTmp2 = new v3d.Quaternion();
_pGlob.colorTmp = new v3d.Color();
_pGlob.mat4Tmp = new v3d.Matrix4();
_pGlob.planeTmp = new v3d.Plane();
_pGlob.raycasterTmp = new v3d.Raycaster();

var PL = v3d.PL = v3d.PL || {};

// a more readable alias for PL (stands for "Puzzle Logic")
v3d.puzzles = PL;

PL.procedures = PL.procedures || {};




function findScormAPI(win) {
    var findScormAPITries = 0;

    while (win.API == null && win.parent != null && win.parent != win) {
        findScormAPITries++;

        if (findScormAPITries > 7) {
            console.error('findScormAPI: Error finding API - too deeply nested.');
            return null;
        }

        win = win.parent;
    }

    return (win.API || null);
}

function findScormAPIOpener(win) {
    if (win.opener != null && typeof(win.opener) != 'undefined')
        return findScormAPI(win.opener);
    else
        return null;
}

function getScormAPI() {
    // start by looking for the API in the current window
    var theAPI = findScormAPI(window);

    // check for opener
    if (theAPI == null)
        theAPI = findScormAPIOpener(window);

    // check for parent opener
    if (theAPI == null && window.parent != null && window.parent != window)
        theAPI = findScormAPIOpener(window.parent);

    // if the API has not been found
    if (theAPI == null)
        console.error('getScormAPI: Unable to find an API adapter');

    return theAPI;
}

var scormAPI = getScormAPI();



PL.execInitPuzzles = function(options) {
    // always null, should not be available in "init" puzzles
    var appInstance = null;
    // app is more conventional than appInstance (used in exec script and app templates)
    var app = null;

    var _initGlob = {};
    _initGlob.percentage = 0;
    _initGlob.output = {
        initOptions: {
            fadeAnnotations: true,
            useBkgTransp: false,
            preserveDrawBuf: false,
            useCompAssets: false,
            useFullscreen: true,
            useCustomPreloader: false,
            preloaderStartCb: function() {},
            preloaderProgressCb: function() {},
            preloaderEndCb: function() {},
        }
    }

    // provide the container's id to puzzles that need access to the container
    _initGlob.container = options !== undefined && 'container' in options
            ? options.container : "";

    

    var PROC = {
    
};


    return _initGlob.output;
}

PL.init = function(appInstance, initOptions) {

// app is more conventional than appInstance (used in exec script and app templates)
var app = appInstance;

initOptions = initOptions || {};

if ('fadeAnnotations' in initOptions) {
    _pGlob.fadeAnnotations = initOptions.fadeAnnotations;
}

this.procedures["do_quiz"] = do_quiz;

var PROC = {
    "do_quiz": do_quiz,
};


function LMSFinish() {
    return (function() {
        // LMSFinish puzzle
	if (scormAPI !== null)
            return scormAPI.LMSFinish('');
    }).apply(null, arguments);
}



// utility functions envoked by the HTML puzzles
function getElements(ids, isParent) {
    var elems = [];
    if (Array.isArray(ids) && ids[0] != 'CONTAINER' && ids[0] != 'WINDOW' &&
        ids[0] != 'DOCUMENT' && ids[0] != 'BODY' && ids[0] != 'QUERYSELECTOR') {
        for (var i = 0; i < ids.length; i++)
            elems.push(getElement(ids[i], isParent));
    } else {
        elems.push(getElement(ids, isParent));
    }
    return elems;
}

function getElement(id, isParent) {
    var elem;
    if (Array.isArray(id) && id[0] == 'CONTAINER') {
        if (appInstance !== null) {
            elem = appInstance.container;
        } else if (typeof _initGlob !== 'undefined') {
            // if we are on the initialization stage, we still can have access
            // to the container element
            var id = _initGlob.container;
            if (isParent) {
                elem = parent.document.getElementById(id);
            } else {
                elem = document.getElementById(id);
            }
        }
    } else if (Array.isArray(id) && id[0] == 'WINDOW') {
        if (isParent)
            elem = parent;
        else
            elem = window;
    } else if (Array.isArray(id) && id[0] == 'DOCUMENT') {
        if (isParent)
            elem = parent.document;
        else
            elem = document;
    } else if (Array.isArray(id) && id[0] == 'BODY') {
        if (isParent)
            elem = parent.document.body;
        else
            elem = document.body;
    } else if (Array.isArray(id) && id[0] == 'QUERYSELECTOR') {
        if (isParent)
            elem = parent.document.querySelector(id);
        else
            elem = document.querySelector(id);
    } else {
        if (isParent)
            elem = parent.document.getElementById(id);
        else
            elem = document.getElementById(id);
    }
    return elem;
}



// eventHTMLElem puzzle
function eventHTMLElem(eventType, ids, isParent, callback) {
    var elems = getElements(ids, isParent);
    for (var i = 0; i < elems.length; i++) {
        var elem = elems[i];
        if (!elem)
            continue;
        elem.addEventListener(eventType, callback);
        if (v3d.PL.editorEventListeners)
            v3d.PL.editorEventListeners.push([elem, eventType, callback]);
    }
}



function LMSInitialize() {
    return (function() {
        // LMSInitialize puzzle
	if (scormAPI !== null)
            return scormAPI.LMSInitialize('');
    }).apply(null, arguments);
}



// createObject puzzle
function createObject(type, name, width, height, depth, radius, tube, segments, cameraType, lightType, fov) {

    var oldObj = appInstance.scene.getObjectByName(name);
    if (oldObj) {
        oldObj.parent.remove(oldObj);
    }

    var obj;
    var geometry;

    switch (type) {
        case 'BOX':
            geometry = new v3d.BoxGeometry(width, height, depth);
            break;
        case 'CAMERA':
            var aspect = appInstance.container.offsetWidth / appInstance.container.offsetHeight;

            if (cameraType == 'PERSPECTIVE') {

                obj = new v3d.PerspectiveCamera(fov, aspect, 1, 1000);

            } else {

                var width = fov * aspect;
                obj = new v3d.OrthographicCamera(-width/2, width/2, fov/2, -fov/2, -1000, 1000);

            }

            obj.lookAt(_pGlob.vec3Tmp.set(0, 0, 0));
            break;
        case 'CIRCLE':
            geometry = new v3d.CircleGeometry(radius, segments);
            break;
        case 'CONE':
            geometry = new v3d.ConeGeometry(radius, height, segments);
            break;
        case 'CYLINDER':
            geometry = new v3d.CylinderGeometry(radius, radius, height, segments);
            break;
        case 'EMPTY':
            obj = new v3d.Object3D();
            break;
        case 'LIGHT':
            var color = 0xffffff;
            var intensity = 0.5;

            switch (lightType) {
                case 'AMBIENT':
                    obj = new v3d.AmbientLight(color, intensity);
                    break;
                case 'AREA':
                    v3d.RectAreaLightUniformsLib.init(LTC_MAT_1, LTC_MAT_2);
                    obj = new v3d.RectAreaLight(color, intensity, 1, 1);
                    break;
                case 'DIRECTIONAL':
                    obj = new v3d.DirectionalLight(color, intensity);
                    break;
                case 'HEMISPHERE':
                    obj = new v3d.HemisphereLight(color, 0, intensity);
                    break;
                case 'POINT':
                    obj = new v3d.PointLight(color, intensity);
                    break;
                case 'SPOT':
                    obj = new v3d.SpotLight(color, intensity);
                    break;
            }

            obj.isFreeLight = true;

            break;
        case 'PLANE':
            geometry = new v3d.PlaneGeometry(width, height, 1, 1);
            break;
        case 'SPHERE':
            geometry = new v3d.SphereGeometry(radius, 32, 32);
            break;
        case 'TEAPOT':
            geometry = new v3d.TeapotGeometry(width);
            break;
        case 'TORUS':
            geometry = new v3d.TorusGeometry(radius, tube, 32, 32);
            break;
    }

    if (geometry) {
        var material = new v3d.MeshStandardMaterial({
            color: 'white',
            roughness: 1.0,
            metalness: 0.0,
            side: (type == 'CIRCLE' || type == 'PLANE' || type == 'TEAPOT') ? v3d.DoubleSide : v3d.FrontSide
        });

        material.name = name + 'Material';

        obj = new v3d.Mesh(geometry, material);
    }

    obj.name = name;

    appInstance.scene.add(obj);

    // clean object cache
    _pGlob.objCache = {};

}



// createTextObject puzzle
function createTextObject(name, text, font, size, height, alignX, alignY, segments, bevelThickness, bevelSize, doCb) {

    var oldObj = appInstance.scene.getObjectByName(name);

    var material = new v3d.MeshStandardMaterial({
        color: 'white',
        roughness: 1.0,
        metalness: 0.0,
        side: (height == 0) ? v3d.DoubleSide : v3d.FrontSide
    });

    material.name = name + 'Material';

    var obj = new v3d.Mesh(new v3d.BufferGeometry(), material);
    obj.name = name;

    appInstance.scene.add(obj);

    // clean object cache
    _pGlob.objCache = {};

    var loader = new v3d.TTFLoader();
    loader.setCrossOrigin('Anonymous');

    v3d.loadModule('opentype.js', function() {
        loader.load(font, function(json) {

            // NOTE: fix possible double-delete errors
            if (oldObj && oldObj.parent) {
                oldObj.parent.remove(oldObj);
            }

            var font = new v3d.Font(json);

            var geometry = new v3d.TextGeometry(text, {

                font: font,

                size: size,
                height: height,
                curveSegments: segments,

                bevelThickness: bevelThickness,
                bevelSize: bevelSize,
                bevelEnabled: (bevelSize > 0 || bevelThickness > 0),

                alignX: alignX,
                alignY: alignY

            });

            obj.geometry = geometry;

            doCb(obj);
        });
    }, function() {
        console.error('create text object: opentype.js module not found, please copy it to your app directory');
    });

}




// utility function envoked by almost all V3D-specific puzzles
// filter off some non-mesh types
function notIgnoredObj(obj) {
    return obj.type !== 'AmbientLight' &&
           obj.name !== '' &&
           !(obj.isMesh && obj.isMaterialGeneratedMesh) &&
           !obj.isAuxClippingMesh;
}


// utility function envoked by almost all V3D-specific puzzles
// find first occurence of the object by its name
function getObjectByName(objName) {
    var objFound;
    var runTime = _pGlob !== undefined;
    objFound = runTime ? _pGlob.objCache[objName] : null;

    if (objFound && objFound.name === objName)
        return objFound;

    appInstance.scene.traverse(function(obj) {
        if (!objFound && notIgnoredObj(obj) && (obj.name == objName)) {
            objFound = obj;
            if (runTime) {
                _pGlob.objCache[objName] = objFound;
            }
        }
    });
    return objFound;
}


// utility function envoked by almost all V3D-specific puzzles
// retrieve all objects on the scene
function getAllObjectNames() {
    var objNameList = [];
    appInstance.scene.traverse(function(obj) {
        if (notIgnoredObj(obj))
            objNameList.push(obj.name)
    });
    return objNameList;
}


// utility function envoked by almost all V3D-specific puzzles
// retrieve all objects which belong to the group
function getObjectNamesByGroupName(targetGroupName) {
    var objNameList = [];
    appInstance.scene.traverse(function(obj){
        if (notIgnoredObj(obj)) {
            var groupNames = obj.groupNames;
            if (!groupNames)
                return;
            for (var i = 0; i < groupNames.length; i++) {
                var groupName = groupNames[i];
                if (groupName == targetGroupName) {
                    objNameList.push(obj.name);
                }
            }
        }
    });
    return objNameList;
}


// utility function envoked by almost all V3D-specific puzzles
// process object input, which can be either single obj or array of objects, or a group
function retrieveObjectNames(objNames) {
    var acc = [];
    retrieveObjectNamesAcc(objNames, acc);
    return acc.filter(function(name) {
        return name;
    });
}

function retrieveObjectNamesAcc(currObjNames, acc) {
    if (typeof currObjNames == "string") {
        acc.push(currObjNames);
    } else if (Array.isArray(currObjNames) && currObjNames[0] == "GROUP") {
        var newObj = getObjectNamesByGroupName(currObjNames[1]);
        for (var i = 0; i < newObj.length; i++)
            acc.push(newObj[i]);
    } else if (Array.isArray(currObjNames) && currObjNames[0] == "ALL_OBJECTS") {
        var newObj = getAllObjectNames();
        for (var i = 0; i < newObj.length; i++)
            acc.push(newObj[i]);
    } else if (Array.isArray(currObjNames)) {
        for (var i = 0; i < currObjNames.length; i++)
            retrieveObjectNamesAcc(currObjNames[i], acc);
    }
}





/**
 * Retrieve coordinate system from the loaded scene
 */
function getCoordSystem() {
    var scene = appInstance.scene;

    if (scene && "v3d" in scene.userData && "coordSystem" in scene.userData.v3d) {
        return scene.userData.v3d.coordSystem;
    } else {
        // COMPAT: <2.17, consider replacing to 'Y_UP_RIGHT' for scenes with unknown origin
        return 'Z_UP_RIGHT';
    }
}


/**
 * Transform coordinates from one space to another
 * Can be used with Vector3 or Euler.
 */
function coordsTransform(coords, from, to, noSignChange) {

    if (from == to)
        return coords;

    var y = coords.y, z = coords.z;

    if (from == 'Z_UP_RIGHT' && to == 'Y_UP_RIGHT') {
        coords.y = z;
        coords.z = noSignChange ? y : -y;
    } else if (from == 'Y_UP_RIGHT' && to == 'Z_UP_RIGHT') {
        coords.y = noSignChange ? z : -z;
        coords.z = y;
    } else {
        console.error('coordsTransform: Unsupported coordinate space');
    }

    return coords;
}


/**
 * Verge3D euler rotation to Blender/Max shortest.
 * 1) Convert from intrinsic rotation (v3d) to extrinsic XYZ (Blender/Max default
 *    order) via reversion: XYZ -> ZYX
 * 2) swizzle ZYX->YZX
 * 3) choose the shortest rotation to resemble Blender's behavior
 */
var eulerV3DToBlenderShortest = function() {

    var eulerTmp = new v3d.Euler();
    var eulerTmp2 = new v3d.Euler();
    var vec3Tmp = new v3d.Vector3();

    return function(euler, dest) {

        var eulerBlender = eulerTmp.copy(euler).reorder('YZX');
        var eulerBlenderAlt = eulerTmp2.copy(eulerBlender).makeAlternative();

        var len = eulerBlender.toVector3(vec3Tmp).lengthSq();
        var lenAlt = eulerBlenderAlt.toVector3(vec3Tmp).lengthSq();

        dest.copy(len < lenAlt ? eulerBlender : eulerBlenderAlt);
        return coordsTransform(dest, 'Y_UP_RIGHT', 'Z_UP_RIGHT');
    }

}();




function RotationInterface() {
    /**
     * For user manipulations use XYZ extrinsic rotations (which
     * are the same as ZYX intrinsic rotations)
     *     - Blender/Max/Maya use extrinsic rotations in the UI
     *     - XYZ is the default option, but could be set from
     *       some order hint if exported
     */
    this._userRotation = new v3d.Euler(0, 0, 0, 'ZYX');
    this._actualRotation = new v3d.Euler();
}

Object.assign(RotationInterface, {
    initObject: function(obj) {
        if (obj.userData.v3d.puzzles === undefined) {
            obj.userData.v3d.puzzles = {}
        }
        if (obj.userData.v3d.puzzles.rotationInterface === undefined) {
            obj.userData.v3d.puzzles.rotationInterface = new RotationInterface();
        }

        var rotUI = obj.userData.v3d.puzzles.rotationInterface;
        rotUI.updateFromObject(obj);
        return rotUI;
    }
});

Object.assign(RotationInterface.prototype, {

    updateFromObject: function(obj) {
        var SYNC_ROT_EPS = 1e-8;

        if (!this._actualRotation.equalsEps(obj.rotation, SYNC_ROT_EPS)) {
            this._actualRotation.copy(obj.rotation);
            this._updateUserRotFromActualRot();
        }
    },

    getActualRotation: function(euler) {
        return euler.copy(this._actualRotation);
    },

    setUserRotation: function(euler) {
        // don't copy the order, since it's fixed to ZYX for now
        this._userRotation.set(euler.x, euler.y, euler.z);
        this._updateActualRotFromUserRot();
    },

    getUserRotation: function(euler) {
        return euler.copy(this._userRotation);
    },

    _updateUserRotFromActualRot: function() {
        var order = this._userRotation.order;
        this._userRotation.copy(this._actualRotation).reorder(order);
    },

    _updateActualRotFromUserRot: function() {
        var order = this._actualRotation.order;
        this._actualRotation.copy(this._userRotation).reorder(order);
    }

});




// setObjTransform puzzle
function setObjTransform(objSelector, isWorldSpace, mode, vector, offset){
    var x = vector[0];
      var y = vector[1];
      var z = vector[2];

    var objNames = retrieveObjectNames(objSelector);

    function setObjProp(obj, prop, val) {
        if (!offset) {
            obj[mode][prop] = val;
        } else {
            if (mode != "scale")
                obj[mode][prop] += val;
            else
                obj[mode][prop] *= val;
        }
    }

    var inputsUsed = _pGlob.vec3Tmp.set(Number(x !== ''), Number(y !== ''),
            Number(z !== ''));
    var coords = _pGlob.vec3Tmp2.set(x || 0, y || 0, z || 0);

    if (mode === 'rotation') {
        // rotations are specified in degrees
        coords.multiplyScalar(v3d.MathUtils.DEG2RAD);
    }

    var coordSystem = getCoordSystem();

    coordsTransform(inputsUsed, coordSystem, 'Y_UP_RIGHT', true);
    coordsTransform(coords, coordSystem, 'Y_UP_RIGHT', mode === 'scale');

    for (var i = 0; i < objNames.length; i++) {

        var objName = objNames[i];
        if (!objName) continue;

        var obj = getObjectByName(objName);
        if (!obj) continue;

        if (isWorldSpace && obj.parent) {
            obj.matrixWorld.decomposeE(obj.position, obj.rotation, obj.scale);

            if (inputsUsed.x) setObjProp(obj, "x", coords.x);
            if (inputsUsed.y) setObjProp(obj, "y", coords.y);
            if (inputsUsed.z) setObjProp(obj, "z", coords.z);

            obj.matrixWorld.composeE(obj.position, obj.rotation, obj.scale);
            obj.matrix.multiplyMatrices(_pGlob.mat4Tmp.copy(obj.parent.matrixWorld).invert(), obj.matrixWorld);
            obj.matrix.decompose(obj.position, obj.quaternion, obj.scale);

        } else if (mode === 'rotation' && coordSystem == 'Z_UP_RIGHT') {
            // Blender/Max coordinates

            // need all the rotations for order conversions, especially if some
            // inputs are not specified
            var euler = eulerV3DToBlenderShortest(obj.rotation, _pGlob.eulerTmp);
            coordsTransform(euler, coordSystem, 'Y_UP_RIGHT');

            if (inputsUsed.x) euler.x = offset ? euler.x + coords.x : coords.x;
            if (inputsUsed.y) euler.y = offset ? euler.y + coords.y : coords.y;
            if (inputsUsed.z) euler.z = offset ? euler.z + coords.z : coords.z;

            /**
             * convert from Blender/Max default XYZ extrinsic order to v3d XYZ
             * intrinsic with reversion (XYZ -> ZYX) and axes swizzling (ZYX -> YZX)
             */
            euler.order = "YZX";
            euler.reorder(obj.rotation.order);
            obj.rotation.copy(euler);

        } else if (mode === 'rotation' && coordSystem == 'Y_UP_RIGHT') {
            // Maya coordinates

            // Use separate rotation interface to fix ambiguous rotations for Maya,
            // might as well do the same for Blender/Max.

            var rotUI = RotationInterface.initObject(obj);
            var euler = rotUI.getUserRotation(_pGlob.eulerTmp);
            // TODO(ivan): this probably needs some reasonable wrapping
            if (inputsUsed.x) euler.x = offset ? euler.x + coords.x : coords.x;
            if (inputsUsed.y) euler.y = offset ? euler.y + coords.y : coords.y;
            if (inputsUsed.z) euler.z = offset ? euler.z + coords.z : coords.z;

            rotUI.setUserRotation(euler);
            rotUI.getActualRotation(obj.rotation);
        } else {
            if (inputsUsed.x) setObjProp(obj, "x", coords.x);
            if (inputsUsed.y) setObjProp(obj, "y", coords.y);
            if (inputsUsed.z) setObjProp(obj, "z", coords.z);

        }

        obj.updateMatrixWorld(true);
    }

}



// updateTextObject puzzle
function updateTextObj(objSelector, text) {
    var objNames = retrieveObjectNames(objSelector);

    for (var i = 0; i < objNames.length; i++) {
        var objName = objNames[i];
        if (!objName) continue;
        var obj = getObjectByName(objName);
        if (!obj || !obj.geometry || !obj.geometry.cloneWithText)
            continue;
        obj.geometry = obj.geometry.cloneWithText(String(text));
    }
}



function matGetColors(matName) {
    var mat = v3d.SceneUtils.getMaterialByName(appInstance, matName);
    if (!mat)
        return [];

    if (mat.isMeshNodeMaterial)
        return Object.keys(mat.nodeRGBMap);
    else if (mat.isMeshStandardMaterial)
        return ['color', 'emissive'];
    else
        return [];
}



// setMaterialColor puzzle
function setMaterialColor(matName, colName, r, g, b, cssCode) {

    var colors = matGetColors(matName);

    if (colors.indexOf(colName) < 0)
        return;

    if (cssCode) {
        var color = new v3d.Color(cssCode);
        color.convertSRGBToLinear();
        r = color.r;
        g = color.g;
        b = color.b;
    }

    var mats = v3d.SceneUtils.getMaterialsByName(appInstance, matName);

    for (var i = 0; i < mats.length; i++) {
        var mat = mats[i];

        if (mat.isMeshNodeMaterial) {
            var rgbIdx = mat.nodeRGBMap[colName];
            mat.nodeRGB[rgbIdx].x = r;
            mat.nodeRGB[rgbIdx].y = g;
            mat.nodeRGB[rgbIdx].z = b;
        } else {
            mat[colName].r = r;
            mat[colName].g = g;
            mat[colName].b = b;
        }
        mat.needsUpdate = true;

        if (appInstance.scene !== null) {
            if (mat === appInstance.scene.worldMaterial) {
                appInstance.updateEnvironment(mat);
            }
        }
    }
}



// show and hide puzzles
function changeVis(objSelector, bool) {
    var objNames = retrieveObjectNames(objSelector);

    for (var i = 0; i < objNames.length; i++) {
        var objName = objNames[i]
        if (!objName)
            continue;
        var obj = getObjectByName(objName);
        if (!obj)
            continue;
        obj.visible = bool;
    }
}



function dataModelElements() {
    return (function(element) {
        return element;
    }).apply(null, arguments);
}



function LMSSetValue() {
    return (function(element, value) {
        // LMSSetValue puzzle
	if (scormAPI !== null)
            scormAPI.LMSSetValue(element, value);
    }).apply(null, arguments);
}



function LMSCommit() {
    return (function() {
        // LMSCommit puzzle
	if (scormAPI !== null)
            return scormAPI.LMSCommit('');
    }).apply(null, arguments);
}



// utility function used by the whenClicked, whenHovered and whenDraggedOver puzzles
function initObjectPicking(callback, eventType, mouseDownUseTouchStart, mouseButtons) {

    var elem = appInstance.renderer.domElement;
    elem.addEventListener(eventType, pickListener);
    if (v3d.PL.editorEventListeners)
        v3d.PL.editorEventListeners.push([elem, eventType, pickListener]);

    if (eventType == 'mousedown') {

        var touchEventName = mouseDownUseTouchStart ? 'touchstart' : 'touchend';
        elem.addEventListener(touchEventName, pickListener);
        if (v3d.PL.editorEventListeners)
            v3d.PL.editorEventListeners.push([elem, touchEventName, pickListener]);

    } else if (eventType == 'dblclick') {

        var prevTapTime = 0;

        function doubleTapCallback(event) {

            var now = new Date().getTime();
            var timesince = now - prevTapTime;

            if (timesince < 600 && timesince > 0) {

                pickListener(event);
                prevTapTime = 0;
                return;

            }

            prevTapTime = new Date().getTime();
        }

        var touchEventName = mouseDownUseTouchStart ? 'touchstart' : 'touchend';
        elem.addEventListener(touchEventName, doubleTapCallback);
        if (v3d.PL.editorEventListeners)
            v3d.PL.editorEventListeners.push([elem, touchEventName, doubleTapCallback]);
    }

    var raycaster = new v3d.Raycaster();

    function pickListener(event) {

        // to handle unload in loadScene puzzle
        if (!appInstance.getCamera())
            return;

        event.preventDefault();

        var xNorm = 0, yNorm = 0;
        if (event instanceof MouseEvent) {
            if (mouseButtons && mouseButtons.indexOf(event.button) == -1)
                return;
            xNorm = event.offsetX / elem.clientWidth;
            yNorm = event.offsetY / elem.clientHeight;
        } else if (event instanceof TouchEvent) {
            var rect = elem.getBoundingClientRect();
            xNorm = (event.changedTouches[0].clientX - rect.left) / rect.width;
            yNorm = (event.changedTouches[0].clientY - rect.top) / rect.height;
        }

        _pGlob.screenCoords.x = xNorm * 2 - 1;
        _pGlob.screenCoords.y = -yNorm * 2 + 1;
        raycaster.setFromCamera(_pGlob.screenCoords, appInstance.getCamera(true));
        var objList = [];
        appInstance.scene.traverse(function(obj){objList.push(obj);});
        var intersects = raycaster.intersectObjects(objList);
        callback(intersects, event);
    }
}

function objectsIncludeObj(objNames, testedObjName) {
    if (!testedObjName) return false;

    for (var i = 0; i < objNames.length; i++) {
        if (testedObjName == objNames[i]) {
            return true;
        } else {
            // also check children which are auto-generated for multi-material objects
            var obj = getObjectByName(objNames[i]);
            if (obj && obj.type == "Group") {
                for (var j = 0; j < obj.children.length; j++) {
                    if (testedObjName == obj.children[j].name) {
                        return true;
                    }
                }
            }
        }
    }
    return false;
}

// utility function used by the whenClicked, whenHovered, whenDraggedOver, and raycast puzzles
function getPickedObjectName(obj) {
    // auto-generated from a multi-material object, use parent name instead
    if (obj.isMesh && obj.isMaterialGeneratedMesh && obj.parent) {
        return obj.parent.name;
    } else {
        return obj.name;
    }
}



// whenClicked puzzle
function registerOnClick(objSelector, xRay, doubleClick, mouseButtons, cbDo, cbIfMissedDo) {

    // for AR/VR
    _pGlob.objClickInfo = _pGlob.objClickInfo || [];

    _pGlob.objClickInfo.push({
        objSelector: objSelector,
        callbacks: [cbDo, cbIfMissedDo]
    });

    initObjectPicking(function(intersects, event) {

        var isPicked = false;

        var maxIntersects = xRay ? intersects.length : Math.min(1, intersects.length);

        for (var i = 0; i < maxIntersects; i++) {
            var obj = intersects[i].object;
            var objName = getPickedObjectName(obj);
            var objNames = retrieveObjectNames(objSelector);

            if (objectsIncludeObj(objNames, objName)) {
                // save the object for the pickedObject block
                _pGlob.pickedObject = objName;
                isPicked = true;
                cbDo(event);
            }
        }

        if (!isPicked) {
            _pGlob.pickedObject = '';
            cbIfMissedDo(event);
        }

    }, doubleClick ? 'dblclick' : 'mousedown', false, mouseButtons);
}


// Describe this function...
function do_quiz() {
  createObject('CONE', 'myObject', 0, 2, 0, 1, 0, 32, 'PERSPECTIVE', 'AMBIENT', 0);
  createTextObject('info', 'What\'s the name of this geometry primitive?', 'https://cdn.soft8soft.com/fonts/roboto.woff', 0.4, 0, 'center', 'center', 10, 0, 0, function() {});
  createTextObject('textSphere', 'Sphere', 'https://cdn.soft8soft.com/fonts/roboto.woff', 0.5, 0.1, 'center', 'center', 10, 0, 0, function() {});
  createTextObject('textCone', 'Cone', 'https://cdn.soft8soft.com/fonts/roboto.woff', 0.5, 0.1, 'center', 'center', 10, 0, 0, function() {});
  createTextObject('textCylinder', 'Cylinder', 'https://cdn.soft8soft.com/fonts/roboto.woff', 0.5, 0.1, 'center', 'center', 10, 0, 0, function() {});
  setObjTransform('textSphere', false, 'position', [3, '', -1], false);
  setObjTransform('textCone', false, 'position', [5, '', -1], false);
  setObjTransform('textCylinder', false, 'position', [7, '', -1], false);
  registerOnClick('textSphere', false, false, [0,1,2], function() {
    updateTextObj('info', 'Wrong! You failed!');
    setMaterialColor('infoMaterial', 'color', 1, 0, 0, '');
    changeVis('textCone', false);
    changeVis('textCylinder', false);
    LMSSetValue(dataModelElements('cmi.core.lesson_status'), 'failed');LMSSetValue(dataModelElements('cmi.core.score.raw'), '0');LMSCommit();}, function() {});
  registerOnClick('textCone', false, false, [0,1,2], function() {
    updateTextObj('info', 'Correct!');
    setMaterialColor('infoMaterial', 'color', 0, 1, 0, '');
    changeVis('textSphere', false);
    changeVis('textCylinder', false);
    LMSSetValue(dataModelElements('cmi.core.lesson_status'), 'passed');LMSSetValue(dataModelElements('cmi.core.score.raw'), '100');LMSCommit();}, function() {});
  registerOnClick('textCylinder', false, false, [0,1,2], function() {
    updateTextObj('info', 'Wrong! You failed!');
    setMaterialColor('infoMaterial', 'color', 1, 0, 0, '');
    changeVis('textCone', false);
    changeVis('textSphere', false);
    LMSSetValue(dataModelElements('cmi.core.lesson_status'), 'failed');LMSSetValue(dataModelElements('cmi.core.score.raw'), '0');LMSCommit();}, function() {});
}


function getItemID() {
    return (function(isParent) {
	var targetWindow = isParent ? window.parent : window;

        var params = v3d.AppUtils.getPageParams(targetWindow);
	if (params['v3d_scorm_item_id'])
            return params['v3d_scorm_item_id'];
        else
            return '';
    }).apply(null, arguments);
}



// createVector puzzle
function createVector(x, y, z) {
    return [x, y, z];
};



// tweenCamera puzzle
function tweenCamera(posOrObj, targetOrObj, duration, doSlot, movementType) {
    var camera = appInstance.getCamera();

    if (Array.isArray(posOrObj)) {
        var worldPos = _pGlob.vec3Tmp.fromArray(posOrObj);
        worldPos = coordsTransform(worldPos, getCoordSystem(), 'Y_UP_RIGHT');
    } else if (posOrObj) {
        var posObj = getObjectByName(posOrObj);
        if (!posObj) return;
        var worldPos = posObj.getWorldPosition(_pGlob.vec3Tmp);
    } else {
        // empty input means: don't change the position
        var worldPos = camera.getWorldPosition(_pGlob.vec3Tmp);
    }

    if (Array.isArray(targetOrObj)) {
        var worldTarget = _pGlob.vec3Tmp2.fromArray(targetOrObj);
        worldTarget = coordsTransform(worldTarget, getCoordSystem(), 'Y_UP_RIGHT');
    } else {
        var targObj = getObjectByName(targetOrObj);
        if (!targObj) return;
        var worldTarget = targObj.getWorldPosition(_pGlob.vec3Tmp2);
    }

    duration = Math.max(0, duration);

    if (appInstance.controls && appInstance.controls.tween) {
        // orbit and flying cameras
        if (!appInstance.controls.inTween) {
            appInstance.controls.tween(worldPos, worldTarget, duration, doSlot,
                    movementType);
        }
    } else {
        // TODO: static camera, just position it for now
        if (camera.parent) {
            camera.parent.worldToLocal(worldPos);
        }
        camera.position.copy(worldPos);
        camera.lookAt(worldTarget);
        doSlot();
    }
}



eventHTMLElem('beforeunload', ['WINDOW'], false, function(event) {
  LMSFinish();});

LMSInitialize();
// __V3D_SCORM_ITEM__{"title":"Learning Geometry Primitives - Cylinder","id":"item_cylinder"}
// __V3D_SCORM_ITEM__{"title":"Learning Geometry Primitives - Cone","id":"item_cone"}
// __V3D_SCORM_ITEM__{"title":"Learning Geometry Primitives - Sphere","id":"item_sphere"}
// __V3D_SCORM_ITEM__{"title":"Geometry Primitives - Quiz","id":"item_quiz"}

if (getItemID(false) == 'item_cylinder') {
  createObject('CYLINDER', 'myObject', 0, 2, 0, 1, 0, 32, 'PERSPECTIVE', 'AMBIENT', 0);
  createTextObject('info', ('A cylinder (from Greek: κύλινδρος) has traditionally' + '\n' +
  'been a three-dimensional solid, one of the most basic' + '\n' +
  'of curvilinear geometric shapes. It is the idealized' + '\n' +
  'version of a solid physical tin can having lids on' + '\n' +
  'top and bottom. Geometrically, it can be considered' + '\n' +
  'as a prism with a circle as its base.'), 'https://cdn.soft8soft.com/fonts/roboto.woff', 0.3, 0, 'center', 'center', 10, 0, 0, function() {});
  LMSSetValue(dataModelElements('cmi.core.lesson_status'), 'passed');LMSCommit();} else if (getItemID(false) == 'item_cone') {
  createObject('CONE', 'myObject', 0, 2, 0, 1, 0, 32, 'PERSPECTIVE', 'AMBIENT', 0);
  createTextObject('info', ('A cone is a three-dimensional geometric shape that' + '\n' +
  'tapers smoothly from a flat base (frequently, though not' + '\n' +
  'necessarily, circular) to a point called the apex or vertex.'), 'https://cdn.soft8soft.com/fonts/roboto.woff', 0.3, 0, 'center', 'center', 10, 0, 0, function() {});
  LMSSetValue(dataModelElements('cmi.core.lesson_status'), 'passed');LMSCommit();} else if (getItemID(false) == 'item_sphere') {
  createObject('SPHERE', 'myObject', 0, 0, 0, 1, 0, 0, 'PERSPECTIVE', 'AMBIENT', 0);
  createTextObject('info', ('A sphere (from Greek σφαiρα) is a geometrical object in' + '\n' +
  'three-dimensional space that is the surface of a ball.' + '\n' +
  'Like a circle in a two-dimensional space, a sphere is' + '\n' +
  'defined mathematically as the set of points that are' + '\n' +
  'all at the same distance r from a given point in' + '\n' +
  'a three-dimensional space.'), 'https://cdn.soft8soft.com/fonts/roboto.woff', 0.3, 0, 'center', 'center', 10, 0, 0, function() {});
  LMSSetValue(dataModelElements('cmi.core.lesson_status'), 'passed');LMSCommit();} else {
  do_quiz();
}

setObjTransform('info', false, 'position', [5, '', ''], false);
tweenCamera(createVector(4, -11, 5), createVector(4, 0, 0), 0, function() {}, 0);



} // end of PL.init function

})(); // end of closure

/* ================================ end of code ============================= */
