<%inherit file="dialog.tpl"/>
<%namespace name="utils" file="utils.tpl"/>

<%block name="blkDialogId">diaCreateNativeApp</%block>

<%block name="blkDialogHeader">
  Create Desktop/Mobile App Template
</%block>

<%block name="blkDialogHeaderHelp">
  ${utils.genManualButton('introduction/Creating-Desktop-Apps.html', 'diaCreateNativeAppHelp')}
</%block>

<%!
  import os
%>

<%block name="blkDialogContent">
  <form action="" id="createNativeAppForm">

    <input type="hidden" name="app" value="${app}">

    <div class="dialog-text">Template:</div>

    <div title="Create desktop application with Electron framework">
      <input type="radio" name="templateName" value="electron" class="dialog-radio" ${'checked' if templateName == 'electron' else ''}>Desktop App (Electron)
    </div>

    <div title="Create mobile application with Apache Cordova framework">
      <input type="radio" name="templateName" value="cordova" class="dialog-radio" ${'checked' if templateName == 'cordova' else ''}>Mobile App (Cordova)
    </div>

    <div id="targetPlatformCont" title="Download Electron binaries and produce a ready-to-use app for the target platform">
      <div class="dialog-text">Target Platform:</div>

      <select name="targetPlatform" class="target-platform">
        <option value="none" ${'selected' if targetPlatform == 'none' else ''}>None (npm package)</option>
        <option value="win32-x64" ${'selected' if targetPlatform == 'win32-x64' else ''}>Windows (64-bit)</option>
        <option value="win32-arm64" ${'selected' if targetPlatform == 'win32-arm64' else ''}>Windows (ARM)</option>
        <option value="win32-ia32" ${'selected' if targetPlatform == 'win32-ia32' else ''}>Windows (32-bit)</option>
        % if showMacPlatforms:
          <option value="darwin-x64" ${'selected' if targetPlatform == 'darwin-x64' else ''}>macOS (64-bit)</option>
          <option value="darwin-arm64" ${'selected' if targetPlatform == 'darwin-arm64' else ''}>macOS (Apple Silicon)</option>
        % endif
        <option value="linux-x64" ${'selected' if targetPlatform == 'linux-x64' else ''}>Linux (64-bit)</option>
        <option value="linux-arm64" ${'selected' if targetPlatform == 'linux-arm64' else ''}>Linux (ARM)</option>
      </select>
    </div>

    <div class="dialog-text">App Name:</div>
    <span title="Application name"><input type="text" name="appName" value="${appName}" class="dialog-semi-wide-input"></span>

    <div class="dialog-text">App ID:</div>
    <span title="Application ID in reverse domain name notation"><input type="text" id="appID" name="appID" value="${appID}" class="dialog-semi-wide-input" spellcheck="false"></span>

    <div class="dialog-text">App Version:</div>
    <span title="Application version"><input type="text" name="appVersion" value="${appVersion}" class="dialog-semi-wide-input"></span>

    <div class="dialog-text">Description:</div>
    <span title="Application description"><input type="text" name="appDescription" value="${appDescription}" class="dialog-semi-wide-input"></span>

    <div class="dialog-text">Author Name:</div>
    <span title="Author name"><input type="text" id="authorName" name="authorName" value="${authorName}" class="dialog-semi-wide-input"></span>

    <div id="electronSettings">
      <div title="Run the app in fullscreen mode">
        <input type="checkbox" name="showFullscreen" value="true" ${'checked' if showFullscreen == 'true' else ''} class="native-app-checker">
        <div class="dialog-text checker-label">Fullscreen</div>
      </div>
    </div>

    <div id="cordovaSettings">
      <div class="dialog-text">Author Email:</div>
      <span title="Author email"><input type="text" id="authorEmail" name="authorEmail" value="${authorEmail}" class="dialog-semi-wide-input" spellcheck="false"></span>

      <div class="dialog-text">Author Website:</div>
      <span title="Author website URL"><input type="text" id="authorWebsite" name="authorWebsite" value="${authorWebsite}" class="dialog-semi-wide-input" spellcheck="false"></span>
    </div>

    <input type="submit" value="Create App" class="button">

  </form>

  <div class="spinner-preloader-cont" id="creatingNativeAppPercentageCont">
    <div class="spinner-preloader"></div>
    <div class="dialog-text-creating-native-app">Creating the App...</div>
  </div>

</%block>

<%block name="blkDialogScript">
    function switchNativeAppDiaMode(mode) {
        if (mode == 'form') {
            createNativeAppForm.style.display = 'block';
            creatingNativeAppPercentageCont.style.display = 'none';
        } else {
            createNativeAppForm.style.display = 'none';
            creatingNativeAppPercentageCont.style.display = 'block';
        }
    }
    switchNativeAppDiaMode('form');

    diaCreateNativeAppClose.addEventListener('click', function() {
        switchNativeAppDiaMode('form');
        destroyDialog('diaCreateNativeApp');
    });

    createNativeAppForm.addEventListener('submit', function(event) {
        var newAppFormData = new FormData(createNativeAppForm);

        makeRequest('/create_native_app/do', newAppFormData, function(response) {
            switchNativeAppDiaMode('form');
            destroyDialog('diaCreateNativeApp');

            const dia = appendDialog(response);
            openDialog(dia);
        });

        switchNativeAppDiaMode('preloader');
        event.preventDefault();
    });

    function templateChangedCb(event) {
        var template = event.currentTarget.value;

        switch (template) {
        case 'electron':
            targetPlatformCont.style.display = 'block';
            electronSettings.style.display = 'block';
            cordovaSettings.style.display = 'none';
            diaCreateNativeAppHelp.href = '${utils.genManualURL('introduction/Creating-Desktop-Apps.html')}';
            break;

        case 'cordova':
            targetPlatformCont.style.display = 'none';
            electronSettings.style.display = 'none';
            cordovaSettings.style.display = 'block';
            diaCreateNativeAppHelp.href = '${utils.genManualURL('introduction/Creating-Mobile-Apps.html')}';
            break;
        }
    };

    createNativeAppForm.templateName.forEach(function(elem) {
        elem.addEventListener('change', templateChangedCb);
    });

    templateChangedCb({currentTarget: {value: '${templateName}'}});

</%block>
