<%namespace name="utils" file="utils.tpl"/>

<html>
<head>
  <title>Verge3D App Manager</title>
  <%include file="head.tpl"/>

  <script>
    const PING_TIMEOUT = 200;

    async function pingServer() {
        const controller = new AbortController()
        const timeoutId = setTimeout(() => controller.abort(), PING_TIMEOUT);

        try {
            await fetch('/ping', { signal: controller.signal });
            clearTimeout(timeoutId);
            return true;
        } catch (e) {
            return false;
        }
    }

    async function pingLoop() {
        const pingResult = await pingServer();
        if (pingResult) {
            location.reload();
        } else {
            setTimeout(pingLoop, PING_TIMEOUT);
        }
    }

    pingLoop();
  </script>
</head>

<body>
  <div class="main-panel">

    <div class="banner"></div>

    <table class="network-directory">
      <thead>
        <tr>
          <th colspan=2>
            App Manager Connection Error
          </th>
        </tr>
      </thead>

      <tbody>
        <tr>
          <td colspan=2>
            <div class="error-message">
              <p>Could not connect to the local server!</p>
              <p>Please launch App Manager from the modelling suite, or via desktop icon / Start menu.</p>
            </div>
          </td>
        </tr>
      </tbody>
      <tfoot><tr><td colspan=2>© 2017-2025 Soft8Soft</td></tr></tfoot>
    </table>

  </div>

</body>
</html>
