# remove manually added Soft8Soft repository

def register():
    import bpy, os
    if bpy.app.version < (4, 2, 0):
        return

    repos = bpy.context.preferences.extensions.repos

    if 'Soft8Soft' in repos:
        repo = repos['Soft8Soft']

        if repo.use_custom_directory:
            print('V3D-ST-INFO: removing outdated Soft8Soft repository')
            repos.remove(repo)

def unregister():
    import os
    try:
        print('V3D-ST-INFO: removing repo migration script {}'.format(__file__))
        os.remove(__file__)
    except:
        print('V3D-ST-INFO: failed to remove repo migration script')
        print('V3D-ST-INFO: please remove {} manually'.format(__file__))
