VERGE3D_ID = 'bl_ext.soft8soft.verge3d'

def register():
    import bpy, os
    if bpy.app.version < (4, 2, 0):
        return

    repos = bpy.context.preferences.extensions.repos

    if 'Soft8Soft' in repos:
        repo = repos['Soft8Soft']
        enable = False
    else:
        print('V3D-ST-INFO: Creating Soft8Soft repository')

        repo = repos.new(
            name='Soft8Soft',
            module='soft8soft'
        )

        enable = True

    def timer():
        if enable:
            import addon_utils
            is_enabled, is_loaded = addon_utils.check(VERGE3D_ID)
            if not is_enabled:
                print('V3D-ST-INFO: Enabling Verge3D extension')
                bpy.ops.preferences.addon_enable(module=VERGE3D_ID)

    # check if verge3d is actually installed
    if os.path.isdir(repo.directory) and os.path.isdir(os.path.join(repo.directory, 'verge3d')):
        bpy.app.timers.register(timer, first_interval=1, persistent=True)

def unregister():
    pass

if __name__ == "__main__":
    register()
